/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmYesNoCancelDialog;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminUnlockWork {
    private boolean m_bCanceled = false;
    private boolean m_bSave = false;
    private Vector m_vErrors = new Vector();
    private VWAdminResultPane m_resultsPane;
    private VWTable m_resultsTable;
    private int[] m_selectedRows;
    private int[] m_selectedCols;
    private VWAdminResultTableModelBase m_tableModel;
    private Vector m_wobsList = new Vector();
    private VWParticipant m_logonUser = null;
    private Frame m_parentFrame = null;
    private Container m_mainContainer = null;
    private ListSelectionModel m_listSelectionModel = null;

    public VWAdminUnlockWork(VWAdminResultPane resultsPane, boolean bAll) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_selectedCols = this.m_resultsPane.getSelectedCols();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_unlockTitle, 1, null);
            this.m_bCanceled = true;
            return;
        }
        if (!bAll && this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_unlockTitle, 1, null);
            this.m_bCanceled = true;
            return;
        }
        int[] rows = new int[this.m_resultsTable.getRowCount()];
        if (bAll) {
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = i;
            }
            this.buildWobsList(rows, bAll);
        } else {
            this.buildWobsList(this.m_selectedRows, bAll);
        }
        if (VWAdminCommon.isAnyWorkModified(this.m_wobsList)) {
            VWAdminConfirmYesNoCancelDialog dlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_unlockTitle, VWResource.s_unlockAndSaveConfirmMessage, 0);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                this.m_bCanceled = true;
                this.removeReferences();
                return;
            }
            this.m_bSave = dlg.isYes();
        }
        this.doUnlock();
        if (bAll) {
            this.m_tableModel.refreshSelectedRows(rows);
        } else {
            this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        }
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_unlockTitle, VWResource.s_unlockErr, this.m_vErrors);
            dlg.setVisible(true);
            this.m_bCanceled = true;
        }
        this.removeReferences();
    }

    private void buildWobsList(int[] rows, boolean bAll) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                if (bAll) {
                    if (woData.getLockedStatus() != 1) continue;
                    this.m_wobsList.addElement(woData);
                    VWAdminCommon.addChildrenToWobsList(woData.getChildren(), true, this.m_wobsList);
                    continue;
                }
                this.m_wobsList.addElement(woData);
                VWAdminCommon.addChildrenToWobsList(woData.getChildren(), false, this.m_wobsList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void doUnlock() {
        boolean bDispatch = false;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                VWWorkObject wob = woData.getWob();
                try {
                    if (this.m_bSave) {
                        wob.doSave(true);
                    } else {
                        wob.doAbort();
                    }
                    wob.doRefresh(false, false);
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m_wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i2);
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doUnlockMany(woArray, this.m_bSave, bDispatch);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(false, false);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    protected boolean getReturnStatus() {
        return this.m_bCanceled;
    }

    private void selectWobs() {
        if (this.m_wobsList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            int rowIndex = woData.getRowIndex();
            if (woData.getLockedStatus() != 3 || rowIndex < 0) continue;
            this.m_listSelectionModel.addSelectionInterval(rowIndex, rowIndex);
        }
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

